//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit

class UMController: UIViewController{
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupScrollView()
        pageSetup()

    }
    
    //MARK:- Page Setup
    
    func pageSetup() {
        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Upcoming meetings"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationItem.rightBarButtonItem = UIBarButtonItem(image:#imageLiteral(resourceName: "logo1").withRenderingMode(.alwaysOriginal), style: .plain , target: self, action: #selector(doNothing))
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    //MARK:- Scroll View
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.translatesAutoresizingMaskIntoConstraints = false
        view.contentSize.height = 850
        view.backgroundColor = .white
        return view
    }()
    
    func setupScrollView() {
        view.addSubview(scrollView)
        scrollView.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        scrollView.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
        scrollView.leftAnchor.constraint(equalTo: view.leftAnchor).isActive = true
        scrollView.rightAnchor.constraint(equalTo: view.rightAnchor).isActive = true
    }
}
